<?php

include 'connection.php';

// Check if the email and device_name parameters are provided
if(isset($_GET['email']) && isset($_GET['devicename'])) {
    // Get the email and device_name parameter values
    $email = $_GET['email'];
    $devicename = $_GET['devicename'];
    
    // Select data from users table based on the provided email, excluding the specified device name
    $sql = "SELECT email, devicename, token , lockstatus, erasestatus, locationstatus FROM user WHERE email = :email AND devicename != :devicename";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':email', $email, PDO::PARAM_STR);
    $stmt->bindParam(':devicename', $devicename, PDO::PARAM_STR);

    if ($stmt->execute()) {
        $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($results) {
            // Data found, return all data
            echo json_encode($results);
        } else {
            // No data found for the provided email
            echo "No data found for the provided email";
        }
    } else {
        // Error in executing SQL query
        echo "Error: " . $sql . "<br>" . $stmt->errorInfo()[2];
    }
} else {
    // Email or device_name parameter not provided
    echo "Email or device_name parameter is missing";
}

?>
